/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.convertor;

import java.awt.Image;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.Project;
import org.netbeans.modules.project.uiapi.ProjectConvertorServiceFactory;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.netbeans.spi.project.ui.ProjectConvertor;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Parameters;
import org.openide.util.WeakListeners;

public class ExtProjectConvertorServices
implements ProjectConvertorServiceFactory {
    public Collection<?> createServices(@NonNull Project project, @NonNull ProjectConvertor.Result result) {
        return Collections.singleton(new LogicalView(project, result));
    }

    private static final class LogicalView
    implements LogicalViewProvider,
    LookupListener {
        private final Project project;
        private final ProjectConvertor.Result result;
        private final Lookup.Result<LogicalViewProvider> eventSource;
        private final ChangeSupport support;
        private volatile LogicalViewProvider delegate;

        LogicalView(@NonNull Project project, @NonNull ProjectConvertor.Result result) {
            Parameters.notNull((CharSequence)"project", (Object)project);
            Parameters.notNull((CharSequence)"result", (Object)result);
            this.project = project;
            this.result = result;
            this.support = new ChangeSupport((Object)this);
            this.eventSource = project.getLookup().lookupResult(LogicalViewProvider.class);
            this.eventSource.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)((Object)this), this.eventSource));
        }

        @NonNull
        public Node createLogicalView() {
            AbstractNode original;
            LogicalViewProvider lvp = this.delegate;
            if (lvp != null) {
                return lvp.createLogicalView();
            }
            try {
                FileObject fo = this.project.getProjectDirectory();
                DataObject dobj = DataObject.find((FileObject)fo);
                original = dobj.getNodeDelegate();
            }
            catch (DataObjectNotFoundException dnfe) {
                original = new AbstractNode(Children.LEAF);
            }
            return new Root(this, (Node)original);
        }

        public Node findPath(Node root, Object target) {
            LogicalViewProvider lvp = this.delegate;
            if (lvp != null) {
                return lvp.findPath(root, target);
            }
            return null;
        }

        public void resultChanged(LookupEvent ev) {
            for (LogicalViewProvider lvp : this.eventSource.allInstances()) {
                if (lvp == this) continue;
                this.delegate = lvp;
                this.support.fireChange();
                break;
            }
        }

        public void addChangeListener(@NonNull ChangeListener listener) {
            this.support.addChangeListener(listener);
        }

        public void removeChangeListener(@NonNull ChangeListener listener) {
            this.support.removeChangeListener(listener);
        }

        private static final class Root
        extends FilterNode
        implements ChangeListener {
            private final ProjectConvertor.Result result;
            private volatile Action[] actions;
            private volatile boolean hasDelegate;

            Root(@NonNull LogicalView view, @NonNull Node delegate) {
                super(delegate);
                this.result = view.result;
                view.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)view));
            }

            public String getDisplayName() {
                return this.hasDelegate ? super.getDisplayName() : this.result.getDisplayName();
            }

            public Image getIcon(int type) {
                return this.hasDelegate ? super.getIcon(type) : ImageUtilities.icon2Image((Icon)this.result.getIcon());
            }

            public Action[] getActions(boolean context) {
                return this.hasDelegate ? super.getActions(context) : this.transientActions();
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                Object source = e.getSource();
                if (source instanceof LogicalView) {
                    this.hasDelegate = true;
                    this.changeOriginal(((LogicalView)source).createLogicalView(), true);
                }
            }

            @NonNull
            private Action[] transientActions() {
                Action[] res = this.actions;
                if (res == null) {
                    this.actions = new Action[]{CommonProjectActions.closeProjectAction()};
                    res = this.actions;
                }
                return res;
            }
        }
    }
}

